using System;
using System.Drawing;
using System.Windows.Forms;

class App
{
    public static void Main()
    {
        Application.Run(new MenuForm());
    }
}

class MenuForm : Form
{
    public MenuForm()
    {
        this.ContextMenu = new ContextMenu(SetupMenu());
        this.Menu = new MainMenu(SetupMenu());
    }

    MenuItem[] SetupMenu()
    {
        MenuItem file = new MenuItem("&File");
        file.MenuItems.Add("Exit", new EventHandler(OnExit));

        MenuItem messages = new MenuItem("&Message Boxes");
        EventHandler handler = new EventHandler(OnMessageBox);
        messages.MenuItems.Add("Message Box 1", handler);
        messages.MenuItems.Add("Message Box 2", handler);
        return new MenuItem[] { file, messages };
    }

    void OnExit(Object sender, EventArgs args)
    {
        this.Close();
    }

    void OnMessageBox(Object sender, EventArgs args)
    {
        MenuItem item = sender as MenuItem;
        MessageBox.Show(this, "You selected menu item - " + item.Text);
    }
}
